<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MapLocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'description',
        'x',
        'y',
        'details',
        'order',
        'is_active',
    ];

    protected $casts = [
        'details' => 'array',
        'x' => 'float',
        'y' => 'float',
        'is_active' => 'boolean',
    ];
}